// Coordinates (e.g. of a pixel)
public class Coordinates {
  public int x;  // horizontal coordinate
  public int y;  // vertical coordinate

  // Constructor: point (px, py)
  public Coordinates(int px, int py) {
    x= px; y= py;
  }
}

// ********************************

// A circle with a center and a radius
public class Circle {
  public Coordinates cent; // Center of circle
  public int rad;          // Radius of circle

  // Constructor: circle with center (x,y) and radius r
  public Circle (int x, int y, int r) {
    cent= new Coordinates(x,y);
    rad= r;
  }
  
  // = diameter of this circle
  public int diameter() {
    return 2*rad;
  }
    
  // = area of this circle
  public float area() {
    return (float) (Math.PI * rad * rad);
  }
}
